/*
 * Decompiled with CFR 0.152.
 */
package mx4j.remote;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.remote.NotificationResult;
import javax.management.remote.TargetedNotification;
import mx4j.log.Log;
import mx4j.log.Logger;
import mx4j.remote.NotificationTuple;
import mx4j.remote.RemoteNotificationServerHandler;

public class DefaultRemoteNotificationServerHandler
implements RemoteNotificationServerHandler {
    private static int listenerID;
    private final NotificationListener listener;
    private final Map tuples = new HashMap();
    private final NotificationBuffer buffer;
    private volatile boolean closed;
    static /* synthetic */ Class class$mx4j$remote$DefaultRemoteNotificationServerHandler;

    public DefaultRemoteNotificationServerHandler(Map environment) {
        this.listener = new ServerListener();
        this.buffer = new NotificationBuffer(environment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer generateListenerID(ObjectName name, NotificationFilter filter) {
        Class clazz = class$mx4j$remote$DefaultRemoteNotificationServerHandler == null ? (class$mx4j$remote$DefaultRemoteNotificationServerHandler = DefaultRemoteNotificationServerHandler.class$("mx4j.remote.DefaultRemoteNotificationServerHandler")) : class$mx4j$remote$DefaultRemoteNotificationServerHandler;
        synchronized (clazz) {
            return new Integer(++listenerID);
        }
    }

    public NotificationListener getServerNotificationListener() {
        return this.listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotificationListener(Integer id, NotificationTuple tuple) {
        if (this.closed) {
            return;
        }
        Map map = this.tuples;
        synchronized (map) {
            this.tuples.put(id, tuple);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NotificationTuple removeNotificationListener(Integer id) {
        if (this.closed) {
            return null;
        }
        Map map = this.tuples;
        synchronized (map) {
            return (NotificationTuple)this.tuples.remove(id);
        }
    }

    public NotificationResult fetchNotifications(long sequenceNumber, int maxNotifications, long timeout) throws IOException {
        if (this.closed) {
            throw new IOException("RemoteNotificationServerHandler is closed");
        }
        return this.buffer.getNotifications(sequenceNumber, maxNotifications, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NotificationTuple[] close() {
        Logger logger = this.getLogger();
        this.closed = true;
        this.stopWaitingForNotifications(this.buffer);
        Map map = this.tuples;
        synchronized (map) {
            NotificationTuple[] result = this.tuples.values().toArray(new NotificationTuple[this.tuples.size()]);
            this.tuples.clear();
            if (logger.isEnabledFor(10)) {
                logger.debug("RemoteNotificationServerHandler closed, returning: " + Arrays.asList(result));
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopWaitingForNotifications(Object lock) {
        Object object = lock;
        synchronized (object) {
            lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean waitForNotifications(Object lock, long timeout) {
        Logger logger = this.getLogger();
        long start = 0L;
        if (logger.isEnabledFor(10)) {
            logger.debug("Waiting for notifications " + timeout + " ms");
            start = System.currentTimeMillis();
        }
        Object object = lock;
        synchronized (object) {
            try {
                lock.wait(timeout);
            }
            catch (InterruptedException x) {
                Thread.currentThread().interrupt();
            }
        }
        if (logger.isEnabledFor(10)) {
            long elapsed = System.currentTimeMillis() - start;
            logger.debug("Waited for notifications " + elapsed + " ms");
        }
        return true;
    }

    protected TargetedNotification[] filterNotifications(TargetedNotification[] notifications) {
        return notifications;
    }

    private void addNotification(Integer id, Notification notification) {
        this.buffer.add(new TargetedNotification(notification, id));
    }

    protected Logger getLogger() {
        return Log.getLogger(this.getClass().getName());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class NotificationBuffer {
        private final List notifications = new LinkedList();
        private int maxCapacity;
        private int purgeDistance;
        private long firstSequence;
        private long lastSequence;
        private long lowestExpectedSequence = -1L;

        private NotificationBuffer(Map environment) {
            if (environment != null) {
                try {
                    Integer maxCapacityInteger = (Integer)environment.get("jmx.remote.x.buffer.size");
                    if (maxCapacityInteger != null) {
                        this.maxCapacity = maxCapacityInteger;
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                try {
                    Integer purgeDistanceInteger = (Integer)environment.get("jmx.remote.x.notification.purge.distance");
                    if (purgeDistanceInteger != null) {
                        this.purgeDistance = purgeDistanceInteger;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.maxCapacity <= 0) {
                this.maxCapacity = 1024;
            }
            if (this.purgeDistance <= 0) {
                this.purgeDistance = 128;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int getSize() {
            NotificationBuffer notificationBuffer = this;
            synchronized (notificationBuffer) {
                return this.notifications.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void add(TargetedNotification notification) {
            Logger logger = DefaultRemoteNotificationServerHandler.this.getLogger();
            NotificationBuffer notificationBuffer = this;
            synchronized (notificationBuffer) {
                if (this.notifications.size() == this.maxCapacity) {
                    if (logger.isEnabledFor(10)) {
                        logger.debug("Notification buffer full: " + this);
                    }
                    this.removeRange(0, 1);
                }
                this.notifications.add(notification);
                ++this.lastSequence;
                if (logger.isEnabledFor(10)) {
                    logger.debug("Notification added to buffer: " + this);
                }
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeRange(int start, int end) {
            NotificationBuffer notificationBuffer = this;
            synchronized (notificationBuffer) {
                this.notifications.subList(start, end).clear();
                this.firstSequence += (long)(end - start);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long getFirstSequenceNumber() {
            NotificationBuffer notificationBuffer = this;
            synchronized (notificationBuffer) {
                return this.firstSequence;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long getLastSequenceNumber() {
            NotificationBuffer notificationBuffer = this;
            synchronized (notificationBuffer) {
                return this.lastSequence;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private NotificationResult getNotifications(long sequenceNumber, int maxNotifications, long timeout) {
            Logger logger = DefaultRemoteNotificationServerHandler.this.getLogger();
            NotificationBuffer notificationBuffer = this;
            synchronized (notificationBuffer) {
                NotificationResult result = null;
                int size = 0;
                if (sequenceNumber < 0L) {
                    long sequence = this.getLastSequenceNumber();
                    size = new Long(sequence + 1L).intValue();
                    result = new NotificationResult(this.getFirstSequenceNumber(), sequence, new TargetedNotification[0]);
                    if (this.lowestExpectedSequence < 0L) {
                        this.lowestExpectedSequence = sequence;
                    }
                    if (logger.isEnabledFor(10)) {
                        logger.debug("First fetchNotification call: " + this + ", returning " + result);
                    }
                } else {
                    long firstSequence = this.getFirstSequenceNumber();
                    int losts = 0;
                    int start = new Long(sequenceNumber - firstSequence).intValue();
                    if (start < 0) {
                        losts = -start;
                        start = 0;
                    }
                    List sublist = null;
                    boolean send = false;
                    while (size == 0) {
                        int end = this.notifications.size();
                        if (end - start > maxNotifications) {
                            end = start + maxNotifications;
                        }
                        sublist = this.notifications.subList(start, end);
                        size = sublist.size();
                        if (DefaultRemoteNotificationServerHandler.this.closed || send) break;
                        if (size != 0) continue;
                        if (timeout <= 0L) break;
                        if (logger.isEnabledFor(10)) {
                            logger.debug("No notifications to send, waiting " + timeout + " ms");
                        }
                        send = DefaultRemoteNotificationServerHandler.this.waitForNotifications(this, timeout);
                    }
                    TargetedNotification[] notifications = sublist.toArray(new TargetedNotification[size]);
                    notifications = DefaultRemoteNotificationServerHandler.this.filterNotifications(notifications);
                    result = new NotificationResult(firstSequence, sequenceNumber + (long)losts + (long)size, notifications);
                    if (logger.isEnabledFor(10)) {
                        logger.debug("Non-first fetchNotification call: " + this + ", returning " + result);
                    }
                    int purged = this.purgeNotifications(sequenceNumber, size);
                    if (logger.isEnabledFor(10)) {
                        logger.debug("Purged " + purged + " notifications: " + this);
                    }
                }
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int purgeNotifications(long sequenceNumber, int size) {
            int result = 0;
            NotificationBuffer notificationBuffer = this;
            synchronized (notificationBuffer) {
                if (sequenceNumber <= this.lowestExpectedSequence) {
                    long expected;
                    long firstSequence;
                    long lowest = Math.min(this.lowestExpectedSequence, sequenceNumber);
                    if (lowest - (firstSequence = this.getFirstSequenceNumber()) > (long)this.purgeDistance) {
                        int purgeSize = this.purgeDistance >> 1;
                        this.removeRange(0, purgeSize);
                        result = purgeSize;
                    }
                    this.lowestExpectedSequence = expected = Math.max(sequenceNumber + (long)size, firstSequence);
                }
            }
            return result;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer("NotificationBuffer@");
            buffer.append(Integer.toHexString(this.hashCode())).append("[");
            buffer.append("first=").append(this.getFirstSequenceNumber()).append(", ");
            buffer.append("last=").append(this.getLastSequenceNumber()).append(", ");
            buffer.append("size=").append(this.getSize()).append(", ");
            buffer.append("lowestExpected=").append(this.lowestExpectedSequence).append(", ");
            buffer.append("maxCapacity=").append(this.maxCapacity).append(", ");
            buffer.append("purgeDistance=").append(this.purgeDistance).append("]");
            return buffer.toString();
        }
    }

    private class ServerListener
    implements NotificationListener {
        private ServerListener() {
        }

        public void handleNotification(Notification notification, Object handback) {
            Integer id = (Integer)handback;
            DefaultRemoteNotificationServerHandler.this.addNotification(id, notification);
        }
    }
}

